/*
 * Decompiled with CFR 0.152.
 */
package jade;

import jade.core.MicroRuntime;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;

public class MicroBoot {
    private static Logger logger = Logger.getMyLogger("jade.MicroBoot");

    public static void main(String[] args) {
        String propsFile = null;
        try {
            Properties props = MicroBoot.parseCmdLineArgs(args);
            propsFile = props.getProperty("conf");
            if (propsFile != null) {
                props.load(propsFile);
            }
            Logger.initialize(props);
            if (props.getProperty("jvm") == null) {
                props.setProperty("jvm", "j2se");
            }
            MicroRuntime.startJADE(props, new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    logger.log(Logger.INFO, "Exiting now!");
                    System.exit(0);
                }
            });
        }
        catch (IllegalArgumentException iae) {
            logger.log(Logger.SEVERE, "Error reading command line configuration properties. " + iae.getMessage());
            iae.printStackTrace();
            MicroBoot.printUsage();
            System.exit(-1);
        }
        catch (IOException ioe) {
            logger.log(Logger.SEVERE, "Error reading configuration properties from file " + propsFile + ".", ioe);
            MicroBoot.printUsage();
            System.exit(-1);
        }
    }

    private static Properties parseCmdLineArgs(String[] args) throws IllegalArgumentException {
        Properties props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                String name = args[i].substring(1);
                if (++i >= args.length) {
                    throw new IllegalArgumentException("No value specified for property \"" + name + "\"");
                }
                props.setProperty(name, args[i]);
                continue;
            }
            if (props.getProperty("agents") != null && logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "WARNING: overriding agents specification set with the \"-agents\" option");
            }
            String agents = args[i];
            props.setProperty("agents", args[i]);
            if (++i >= args.length) break;
            if (logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "WARNING: ignoring command line argument " + args[i] + " occurring after agents specification");
            }
            if (agents != null && agents.indexOf(40) != -1 && !agents.endsWith(")") && logger.isLoggable(Logger.WARNING)) {
                logger.log(Logger.WARNING, "Note that agent arguments specifications must not contain spaces");
            }
            if (args[i].indexOf(58) == -1 || !logger.isLoggable(Logger.WARNING)) break;
            logger.log(Logger.WARNING, "Note that agent specifications must be separated by a semicolon character \";\" without spaces");
            break;
        }
        return props;
    }

    private static void printUsage() {
        logger.log(Logger.ALL, "Usage:");
        logger.log(Logger.ALL, "java -cp <classpath> jade.MicroBoot [options] [agents]");
        logger.log(Logger.ALL, "Options:");
        logger.log(Logger.ALL, "    -conf <file-name>. Read configuration properties from the specified file name");
        logger.log(Logger.ALL, "    -host <host-name>. The name/address of the host where the BackEnd has to be created");
        logger.log(Logger.ALL, "    -port <port-number>. The port of the J2SE container active on \"host\"");
        logger.log(Logger.ALL, "    -<key> <value>");
        logger.log(Logger.ALL, "Agents: [-agents] <semicolon-separated agent-specifiers>");
        logger.log(Logger.ALL, "     where agent-specifier = <agent-name>:<agent-class>[(comma separated args)]\n");
    }
}

